
// #ifdef USE_DIRECT_OS
// #define SYSTEM_S_IMPORT_INTERFACE_TYPES
// #include "system_pif.h"
// #else
#define OSAL_S_IMPORT_INTERFACE_TYPES
#include "osal_if.h"
// #endif

 
#include "AES.h"
#include "AES_common.h"

#include "AESWriter.h"


AESWriter::AESWriter()
: m_hFile (INVALID_FILE_HANDLE)
, m_u32NumBytesWritten (0)
, m_u32BlocksWritten (0)
, m_poAES (NULL)
, m_u32NumBytesCached (0)
{
}


AESWriter::~AESWriter()
{
   if (m_hFile != INVALID_FILE_HANDLE && bClose() == FALSE)
   {
      // Sauberes Close hat nicht geklappt - ressourcen freigeben!
      fileClose(m_hFile);
      m_hFile = INVALID_FILE_HANDLE;

      if (m_poAES != NULL)
      {
         delete m_poAES;
         m_poAES = NULL;
      }
   }
}

tBool AESWriter::bOpen ( tCString szName, tBool bOverwriteExisting )
{
   tBool bSuccess = FALSE;

   if (m_hFile == INVALID_FILE_HANDLE)
   {
      m_poAES = new AES();

      if (m_poAES != NULL)
      {
         m_poAES->SetParameters(256);
         m_poAES->StartEncryption(keys[0]);

         tBool bExists = FALSE;

         FileHandle hTmp = fileOpenReadOnly(szName);

         if(hTmp != INVALID_FILE_HANDLE)
         {
            bExists = TRUE;
            fileClose(hTmp);
         }

         if (bOverwriteExisting == TRUE && bExists == TRUE)
         {
            bSuccess = removeFile(szName);
         }
         else if (bExists == FALSE)
         {
            bSuccess = TRUE;
         }

         if (bSuccess == TRUE)
         {
            m_hFile = fileOpenWriteOnly(szName);
            bSuccess = bWriteHeader();
         }      

         if (bSuccess == FALSE)
         {
            bClose();
         }
      }
   }

   return bSuccess;
}


tBool AESWriter::bClose()
{
   tBool bSuccess = FALSE;

   if (m_hFile != INVALID_FILE_HANDLE)
   {
      if (bFlush() == TRUE)
      {
         if (  writeFile(&m_u32BlocksWritten, 1, sizeof(m_u32BlocksWritten), m_hFile) == sizeof(m_u32BlocksWritten)
            && writeFile(&m_u32NumBytesWritten, 1, sizeof(m_u32NumBytesWritten), m_hFile) == sizeof(m_u32NumBytesWritten))
         {
            bSuccess = fileClose(m_hFile);
            m_hFile = INVALID_FILE_HANDLE;

            if (m_poAES != NULL)
            {
               delete m_poAES;
               m_poAES = NULL;
            }
         }
      }
   }

   return bSuccess;
}


tBool AESWriter::bWrite(tU8 *pu8Data, tU32 u32NumBytes)
{
   tBool bSuccess = FALSE;

   if (m_hFile != INVALID_FILE_HANDLE && m_poAES != NULL)
   {
      bSuccess = TRUE;
      tU32 u32WritePos = 0;
      tU32 u32BytesLeft = u32NumBytes + m_u32NumBytesCached;
      while (u32BytesLeft >= BLOCKSIZE)
      {
         tU32 u32Blocks = (u32BytesLeft / BLOCKSIZE);
         tU32 u32Bytes  = u32Blocks * BLOCKSIZE;
         
         tU8* poTmpSrc = new tU8[u32Bytes];
         tU8* poTmpDst = new tU8[u32Bytes];
         if (poTmpSrc != NULL && poTmpDst != NULL)
         {
            tU32 u32SrcPos = 0;
            if (m_u32NumBytesCached > 0)
            {
               copyMemory(poTmpSrc, m_au8Cache, m_u32NumBytesCached);
               u32SrcPos = m_u32NumBytesCached;
               m_u32NumBytesCached = 0;
            }

            copyMemory (poTmpSrc + u32SrcPos, pu8Data + u32WritePos, u32Bytes - u32SrcPos);
            u32BytesLeft = u32BytesLeft - (u32Bytes - u32SrcPos);
            u32WritePos += u32Bytes - u32SrcPos;

            m_poAES->Encrypt(poTmpSrc, poTmpDst, u32Blocks);

            if (     writeFile(&u32Blocks, 1, sizeof(u32Blocks), m_hFile) != sizeof(u32Blocks)
                  || writeFile(poTmpDst, 1, u32Bytes, m_hFile) != u32Bytes)
            {
               // Fehler
               bSuccess = FALSE;
              delete[] poTmpSrc;
               delete[] poTmpDst;               
               break;
            }
            m_u32NumBytesWritten += u32Bytes;
            m_u32BlocksWritten   += u32Blocks;

            delete[] poTmpSrc;
            delete[] poTmpDst;
         }
         else
         {
            if (poTmpSrc != NULL)
               delete[] poTmpSrc;
            if (poTmpDst != NULL)
               delete[] poTmpDst;
            break;
         }
      }

      if (u32BytesLeft > 0)
      {
         if (u32NumBytes - u32WritePos <= BLOCKSIZE)
         {
            copyMemory(m_au8Cache, pu8Data + u32WritePos, u32NumBytes - u32WritePos);
            m_u32NumBytesCached =  u32NumBytes - u32WritePos;
         }
         else
         {
            // CRITICAL PROGRAMMATICAL ERROR
            int *p = (int *)0;
            *p = 5;
         }
      }
   }
   return bSuccess;
}



tBool AESWriter::bFlush()
{
   tBool bSuccess = FALSE;
   if (m_hFile != INVALID_FILE_HANDLE)
   {
      if (m_u32NumBytesCached > 0)
      {
         tU8* poTmpDst = new tU8[BLOCKSIZE];
         if (poTmpDst != NULL)
         {
            setMemory( m_au8Cache+m_u32NumBytesCached, 
               0x10, 
               BLOCKSIZE - m_u32NumBytesCached );
            m_poAES->Encrypt(m_au8Cache, poTmpDst, 1);

            tU32 u32Tmp = 1;
            if (     writeFile(&u32Tmp, 1, sizeof(tU32), m_hFile) == sizeof(tU32)
                  && writeFile(poTmpDst, 1, BLOCKSIZE, m_hFile) == BLOCKSIZE)
            {
               m_u32NumBytesWritten += m_u32NumBytesCached;
               m_u32NumBytesCached = 0;
               bSuccess = TRUE;
            }

            delete[] poTmpDst;
         }
      }
      else
      {
         bSuccess = TRUE;
      }
   }
   return bSuccess;
}


tBool AESWriter::bWriteHeader()
{
   /*
    *  4 Byte:  Major Version of File
    *  4 Byte:  Minor Version of File
    *  4 Byte:  ID of Encryption Key
    *
    *  (Data-Bytes)
    *
    *  4 Byte: num blocks written
    *  4 Byte: Size of encrypted user data
    */
   tBool bSuccess = FALSE;

   if (m_hFile != INVALID_FILE_HANDLE)
   {
      tU32 u32Tmp = DEFAULT_FILE_VERSION_MAJOR;
      if (writeFile(&u32Tmp, 1, sizeof(u32Tmp), m_hFile) == sizeof(u32Tmp))
      {
         u32Tmp = DEFAULT_FILE_VERSION_MINOR;
         if (writeFile(&u32Tmp, 1, sizeof(u32Tmp), m_hFile) == sizeof(u32Tmp))
         {
            u32Tmp = DEFAULT_ENCRYPTION_KEY_ID;
            if (writeFile(&u32Tmp, 1, sizeof(u32Tmp), m_hFile) == sizeof(u32Tmp))
            {
               bSuccess = TRUE;
            }
         }
      }
   }
   return bSuccess;
}


